//
//  BaselineLifeExpectancy.swift
//  death_app Watch App
//
//  Baseline life expectancy calculations using actuarial tables
//

import Foundation

class BaselineLifeExpectancy {
    
    /// Get baseline life expectancy for demographics
    func getBaseline(age: Int, gender: Gender) -> Double {
        // Simplified actuarial table - in production would use comprehensive data
        let baseLifeExpectancy: Double
        
        if gender == .male {
            baseLifeExpectancy = getMaleLifeExpectancy(age: age)
        } else {
            baseLifeExpectancy = getFemaleLifeExpectancy(age: age)
        }
        
        return baseLifeExpectancy
    }
    
    private func getMaleLifeExpectancy(age: Int) -> Double {
        // US 2019 actuarial data approximation
        switch age {
        case 0..<20: return 76.1
        case 20..<30: return 76.8
        case 30..<40: return 77.1
        case 40..<50: return 77.6
        case 50..<60: return 78.4
        case 60..<70: return 79.9
        case 70..<80: return 82.7
        case 80..<90: return 87.0
        default: return 92.0
        }
    }
    
    private func getFemaleLifeExpectancy(age: Int) -> Double {
        // US 2019 actuarial data approximation
        switch age {
        case 0..<20: return 81.1
        case 20..<30: return 81.6
        case 30..<40: return 81.8
        case 40..<50: return 82.2
        case 50..<60: return 83.0
        case 60..<70: return 84.5
        case 70..<80: return 87.0
        case 80..<90: return 90.5
        default: return 94.5
        }
    }
}